% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{summary.rqcan}
\alias{summary.rqcan}
\title{Summary of rqcan function results.}
\usage{
\method{summary}{rqcan}(object, pr = TRUE, ci = 1, fact = 1, ...)
}
\arguments{
\item{object}{rqcan object returned by rqcan}

\item{pr}{print tables if TRUE (default)}

\item{ci}{type of 95% confidence interval \cr
ci=1: use (adjusted) .025 and .975 percentiles of bootstrap distribution \cr
ci=2: use normal approx with adjusted SE based on interquartile range \cr
ci may be a vector to provide more than one type of interval; default=1 \cr}

\item{fact}{a factor to adjust conf ints for components 2:na; used only for development \cr}

\item{...}{parameters that are sent to the bootstrap function: \cr
Rep: number of bootstrap replications (default=200) \cr
method: "Andrews" (default) or ""xy" \cr
msub: parameter defining the size of the bootstrap subsample for developmental work only: see the boot.can function \cr
seed: a starting seed (default: missing: no new seed set) \cr
nsing: number of consecutive singular replicatios to ignore (default = 5) \cr
prb: if TRUE (default = FALSE), print every time 10 percent of the bootstrap samples are done \cr}
}
\value{
Returns list(As,Bs,sdc): As and Bs are matrices with Rep rows giving alpha beta coefficients for each bootstrap replication; and sdc is a standard error adjustment based on the subsample bootstrap:   sdc = sqrt(1 - m/n). \cr
\cr
}
\description{
Uses one of two bootstrap methods to provide Standard Error and confidence intervals for the alpha and beta coefficients for all components. \cr
\cr
}
\details{
The Portnoy reference showed that a subsample bootstrap (as described by Andrews) gives consistent estimates of SE's and confidence intervals. The subsample size is m = ceiling( min(n, max(log(n)*(px+py+1), n^msub)) ) (where n = nrow(X), px = ncol(X), py = ncol(Y)), msub is as above). Some simulations and examples suggest that this is OK. The usual "xy" bootstrap (sampling rows independently with replacement) can be specified. It seems to give similar confidence intervals to "Andrews", but the SE estimates may be wrong; and no form of consistency has been proven. Note: as noted in help(rqcan), the quantreg function rq.fit.fnc may generate singular matrices even if the input design matrix is of full rank. In simulation examples, this can happen for some bootstrap replications (perhaps less than 1/1000 times). When this occurs, a new bootstrap replication is drawn. If more than nsing consecutive singularities are produced, the bootstrap function returns with those replications that it has already found (a number less than Rep), with a warning. If a singularity warning occurs, using "xy", or changing the seed or "jittering" the data (see jitter()) sometimes helps. \cr
}
