library(rslp)
context("Apply Rules")
steprules <- readRDS(system.file("steprules.rds", package = "rslp"))

test_that("Plural Reduction Rules", {
  expect_equal(rslp:::apply_rules("bons", name = "Plural", steprules = steprules), "bom")
  expect_equal(rslp:::apply_rules("bal\u00f5es", name = "Plural", steprules = steprules), "bal\u00e3o")
  expect_equal(rslp:::apply_rules("capit\u00e3es", name = "Plural", steprules = steprules), "capit\u00e3o")
  expect_equal(rslp:::apply_rules("normais", name = "Plural", steprules = steprules), "normal")
  expect_equal(rslp:::apply_rules("am\u00e1veis", name = "Plural", steprules = steprules), "am\u00e1vel")
  expect_equal(rslp:::apply_rules("len\u00e7\u00f3is", name = "Plural", steprules = steprules), "len\u00e7ol")
  expect_equal(rslp:::apply_rules("barris", name = "Plural", steprules = steprules), "barril")
  expect_equal(rslp:::apply_rules("males", name = "Plural", steprules = steprules), "mal")
  expect_equal(rslp:::apply_rules("mares", name = "Plural", steprules = steprules), "mar")
  expect_equal(rslp:::apply_rules("casas", name = "Plural", steprules = steprules), "casa")
})

test_that("Feminine Reduction Rules", {
  expect_equal(rslp:::apply_rules("chefona", name = "Feminine", steprules = steprules), "chef\u00e3o")
  expect_equal(rslp:::apply_rules("vil\u00e3", name = "Feminine", steprules = steprules), "vil\u00e3o")
  expect_equal(rslp:::apply_rules("professora", name = "Feminine", steprules = steprules), "professor")
  expect_equal(rslp:::apply_rules("americana", name = "Feminine", steprules = steprules), "americano")
  expect_equal(rslp:::apply_rules("chilena", name = "Feminine", steprules = steprules), "chileno")
  expect_equal(rslp:::apply_rules("inglesa", name = "Feminine", steprules = steprules), "ingl\u00eas")
  expect_equal(rslp:::apply_rules("famosa", name = "Feminine", steprules = steprules), "famoso")
  expect_equal(rslp:::apply_rules("man\u00edaca", name = "Feminine", steprules = steprules), "man\u00edaco")
  expect_equal(rslp:::apply_rules("pr\u00e1tica", name = "Feminine", steprules = steprules), "pr\u00e1tico")
  expect_equal(rslp:::apply_rules("mantida", name = "Feminine", steprules = steprules), "mantido")
  expect_equal(rslp:::apply_rules("cansada", name = "Feminine", steprules = steprules), "cansado")
  expect_equal(rslp:::apply_rules("prima", name = "Feminine", steprules = steprules), "primo")
  expect_equal(rslp:::apply_rules("passiva", name = "Feminine", steprules = steprules), "passivo")
  expect_equal(rslp:::apply_rules("primeira", name = "Feminine", steprules = steprules), "primeiro")
  expect_equal(rslp:::apply_rules("sozinha", name = "Feminine", steprules = steprules), "sozinho")
})

test_that("Adverb Reduction Rule", {
  expect_equal(rslp:::apply_rules("felizmente", name = "Adverb", steprules = steprules), "feliz")
})

test_that("Aumentative/Dimunutive Reduction Rules", {
  expect_equal(rslp:::apply_rules("cansad\u00edssimo", name = "Augmentative", steprules = steprules), "cansa")
  # expect_equal(rslp:::apply_rules("amabil\u00edssimo", name = "Augmentative", steprules = steprules), "ama")
  expect_equal(rslp:::apply_rules("fort\u00edssimo", name = "Augmentative", steprules = steprules), "fort")
  expect_equal(rslp:::apply_rules("chiqu\u00e9rrimo", name = "Augmentative", steprules = steprules), "chiqu")
  expect_equal(rslp:::apply_rules("pezinho", name = "Augmentative", steprules = steprules), "pe")
  expect_equal(rslp:::apply_rules("maluquinho", name = "Augmentative", steprules = steprules), "maluc")
  expect_equal(rslp:::apply_rules("amiguinho", name = "Augmentative", steprules = steprules), "amig")
  expect_equal(rslp:::apply_rules("cansadinho", name = "Augmentative", steprules = steprules), "cans")
  expect_equal(rslp:::apply_rules("carrinho", name = "Augmentative", steprules = steprules), "carr")
  expect_equal(rslp:::apply_rules("grandalh\u00e3o", name = "Augmentative", steprules = steprules), "grand")
  expect_equal(rslp:::apply_rules("dentu\u00e7a", name = "Augmentative", steprules = steprules), "dent")
  expect_equal(rslp:::apply_rules("mulhera\u00e7o", name = "Augmentative", steprules = steprules), "mulher")
  expect_equal(rslp:::apply_rules("cansad\u00e3o", name = "Augmentative", steprules = steprules), "cans")
  expect_equal(rslp:::apply_rules("corp\u00e1zio", name = "Augmentative", steprules = steprules), "corp")
  expect_equal(rslp:::apply_rules("pratarraz", name = "Augmentative", steprules = steprules), "prat")
  expect_equal(rslp:::apply_rules("bocarra", name = "Augmentative", steprules = steprules), "boc")
  expect_equal(rslp:::apply_rules("calorz\u00e3o", name = "Augmentative", steprules = steprules), "calor")
  expect_equal(rslp:::apply_rules("menin\u00e3o", name = "Augmentative", steprules = steprules), "menin")
})

test_that("Noun Reduction Rules", {
  expect_equal(rslp:::apply_rules("existencialista", name = "Noun", steprules = steprules), "exist")
  expect_equal(rslp:::apply_rules("minimalista", name = "Noun", steprules = steprules), "minim")
  expect_equal(rslp:::apply_rules("contagem", name = "Noun", steprules = steprules), "cont")
  expect_equal(rslp:::apply_rules("gerenciamento", name = "Noun", steprules = steprules), "gerenc")
  expect_equal(rslp:::apply_rules("monitoramento", name = "Noun", steprules = steprules), "monitor") # diferente do artigo que est\u00e1 errado
  expect_equal(rslp:::apply_rules("nascimento", name = "Noun", steprules = steprules), "nasc")
  expect_equal(rslp:::apply_rules("comercializado", name = "Noun", steprules = steprules), "comerci")
  expect_equal(rslp:::apply_rules("traumatizado", name = "Noun", steprules = steprules), "traum")
  expect_equal(rslp:::apply_rules("alfabetizado", name = "Noun", steprules = steprules), "alfabet")
  expect_equal(rslp:::apply_rules("associativo", name = "Noun", steprules = steprules), "associ")
  expect_equal(rslp:::apply_rules("contraceptivo", name = "Noun", steprules = steprules), "contracep")
  expect_equal(rslp:::apply_rules("esportivo", name = "Noun", steprules = steprules), "espor") # diferente do artigo. o artigo est\u00e1 errado
  expect_equal(rslp:::apply_rules("abalado", name = "Noun", steprules = steprules), "abal")
  expect_equal(rslp:::apply_rules("impedido", name = "Noun", steprules = steprules), "imped")
  expect_equal(rslp:::apply_rules("ralador", name = "Noun", steprules = steprules), "ral")
  expect_equal(rslp:::apply_rules("entendido", name = "Noun", steprules = steprules), "entend")
  expect_equal(rslp:::apply_rules("cumpridor", name = "Noun", steprules = steprules), "cumpr")
  expect_equal(rslp:::apply_rules("obrigat\u00f3ria", name = "Noun", steprules = steprules), "obrig")
  expect_equal(rslp:::apply_rules("produtor", name = "Noun", steprules = steprules), "produt")
  expect_equal(rslp:::apply_rules("comparabilidade", name = "Noun", steprules = steprules), "compar")
  expect_equal(rslp:::apply_rules("abolicionista", name = "Noun", steprules = steprules), "abol")
  expect_equal(rslp:::apply_rules("intervencionista", name = "Noun", steprules = steprules), "interven")
  expect_equal(rslp:::apply_rules("profissional", name = "Noun", steprules = steprules), "profiss")
  expect_equal(rslp:::apply_rules("refer\u00eancia", name = "Noun", steprules = steprules), "refer")
  expect_equal(rslp:::apply_rules("repugn\u00e2ncia", name = "Noun", steprules = steprules), "repugn")
  expect_equal(rslp:::apply_rules("abatedouro", name = "Noun", steprules = steprules), "abat")
  expect_equal(rslp:::apply_rules("fofoqueiro", name = "Noun", steprules = steprules), "fofoc")
  expect_equal(rslp:::apply_rules("brasileiro", name = "Noun", steprules = steprules), "brasil")
  expect_equal(rslp:::apply_rules("gostoso", name = "Noun", steprules = steprules), "gost")
  expect_equal(rslp:::apply_rules("comercializa\u00e7", name = "Noun", steprules = steprules), "comerci")
  expect_equal(rslp:::apply_rules("consumismo", name = "Noun", steprules = steprules), "consum")
  #expect_equal(rslp:::apply_rules(escp("concretizaç"), name = "Noun", steprules = steprules), "concret")
  expect_equal(rslp:::apply_rules("alega\u00e7", name = "Noun", steprules = steprules), "aleg")
  expect_equal(rslp:::apply_rules("aboli\u00e7", name = "Noun", steprules = steprules), "abol")
  expect_equal(rslp:::apply_rules("anedot\u00e1rio", name = "Noun", steprules = steprules), "anedot")
  expect_equal(rslp:::apply_rules("minist\u00e9rio", name = "Noun", steprules = steprules), "minist")
  expect_equal(rslp:::apply_rules("chin\u00eas", name = "Noun", steprules = steprules), "chin")
  expect_equal(rslp:::apply_rules("beleza", name = "Noun", steprules = steprules), "bel")
  expect_equal(rslp:::apply_rules("rigidez", name = "Noun", steprules = steprules), "rigid")
  expect_equal(rslp:::apply_rules("parentesco", name = "Noun", steprules = steprules), "parent")
  expect_equal(rslp:::apply_rules("ocupante", name = "Noun", steprules = steprules), "ocup")
  expect_equal(rslp:::apply_rules("bomb\u00e1stico", name = "Noun", steprules = steprules), "bomb")
  expect_equal(rslp:::apply_rules("problem\u00e1tico", name = "Noun", steprules = steprules), "problem")
  expect_equal(rslp:::apply_rules("pol\u00eamico", name = "Noun", steprules = steprules), "pol\u00eam")
  expect_equal(rslp:::apply_rules("produtividade", name = "Noun", steprules = steprules), "produt")
  expect_equal(rslp:::apply_rules("profundidade", name = "Noun", steprules = steprules), "profund")
  expect_equal(rslp:::apply_rules("aposentadoria", name = "Noun", steprules = steprules), "aposentad")
  expect_equal(rslp:::apply_rules("anedot\u00e1rio", name = "Noun", steprules = steprules), "anedot")
  expect_equal(rslp:::apply_rules("existencial", name = "Noun", steprules = steprules), "exist")
  expect_equal(rslp:::apply_rules("artista", name = "Noun", steprules = steprules), "artista") # a regra est\u00e1 errada no artigo
  expect_equal(rslp:::apply_rules("maluquice", name = "Noun", steprules = steprules), "maluc")
  expect_equal(rslp:::apply_rules("chatice", name = "Noun", steprules = steprules), "chat")
  expect_equal(rslp:::apply_rules("demon\u00edaco", name = "Noun", steprules = steprules), "demon")
  expect_equal(rslp:::apply_rules("decorrente", name = "Noun", steprules = steprules), "decorr")
  expect_equal(rslp:::apply_rules("criminal", name = "Noun", steprules = steprules), "crim")
  expect_equal(rslp:::apply_rules("americano", name = "Noun", steprules = steprules), "americ")
  expect_equal(rslp:::apply_rules("am\u00e1vel", name = "Noun", steprules = steprules), "am")
  expect_equal(rslp:::apply_rules("combust\u00edvel", name = "Noun", steprules = steprules), "combust")
  expect_equal(rslp:::apply_rules("cobertura", name = "Noun", steprules = steprules), "cobert")
  expect_equal(rslp:::apply_rules("consensual", name = "Noun", steprules = steprules), "consens")
  expect_equal(rslp:::apply_rules("mundial", name = "Noun", steprules = steprules), "mund")
  expect_equal(rslp:::apply_rules("experimental", name = "Noun", steprules = steprules), "experiment")
})

test_that("Verb Reduction Rules", {
  expect_equal(rslp:::apply_rules("cantar\u00edamo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cant\u00e1ssemo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("beber\u00edamo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beb\u00eassemo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partir\u00edamo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("part\u00edssemo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("cant\u00e1ramo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cant\u00e1rei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantaremo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantariam", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantar\u00edei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cant\u00e1ssei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantassem", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cant\u00e1vamo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("beb\u00earamo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberemo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberiam", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beber\u00edei", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beb\u00eassei", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebessem", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partir\u00edamo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partiremo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partiriam", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partir\u00edei", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("part\u00edssei", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partissem", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("cantando", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("bebendo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partindo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("propondo", name = "Verb", steprules = steprules), "prop")
  expect_equal(rslp:::apply_rules("cantaram", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantarde", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantarei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantarem", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantaria", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantarmo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantasse", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantaste", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantavam", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cant\u00e1vei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("beberam", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberde", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberei", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beb\u00earei", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberem", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beberia", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebermo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebesse", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebeste", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beb\u00edamo", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partiram", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("conclu\u00edram", name = "Verb", steprules = steprules), "conclu")
  expect_equal(rslp:::apply_rules("partirde", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partirei", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partirem", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partiria", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partirmo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partisse", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partiste", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("cantamo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantara", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantar\u00e1", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantare", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantava", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantemo", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("bebera", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beber\u00e1", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebere", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebiam", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("beb\u00edei", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partimo", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partira", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partir\u00e1", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partire", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("compomo", name = "Verb", steprules = steprules), "comp")
  expect_equal(rslp:::apply_rules("cantai", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantam", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cheguei", name = "Verb", steprules = steprules), "cheg")
  expect_equal(rslp:::apply_rules("cantei", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("cantem", name = "Verb", steprules = steprules), "cant")
  expect_equal(rslp:::apply_rules("beber", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebeu", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("bebia", name = "Verb", steprules = steprules), "beb")
  expect_equal(rslp:::apply_rules("partir", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("partiu", name = "Verb", steprules = steprules), "part")
  expect_equal(rslp:::apply_rules("chegou", name = "Verb", steprules = steprules), "cheg")
  expect_equal(rslp:::apply_rules("bebi", name = "Verb", steprules = steprules), "beb")
})

test_that("Vowel Reduction Rules", {
  expect_equal(rslp:::apply_rules("menina", name = "Vowel", steprules = steprules), "menin")
  expect_equal(rslp:::apply_rules("grande", name = "Vowel", steprules = steprules), "grand")
  expect_equal(rslp:::apply_rules("menino", name = "Vowel", steprules = steprules), "menin")
})
