% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include.R
\name{rspiro_check_somat}
\alias{rspiro_check_somat}
\title{Check somatometric input data}
\usage{
rspiro_check_somat(
  age,
  height,
  gender,
  ethnicity,
  NHANES = FALSE,
  JRS = FALSE,
  diff = FALSE
)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male)}

\item{ethnicity}{Ethnicity (GLI: 1 = Caucasian, 2 = African-American, 
3 = NE Asian, 4 = SE Asian, 5 = Other/mixed, NHANES: 1 = Caucasian, 
2 = African-American, 3 = Mexican-American)}

\item{NHANES}{Logical. Is input data for the NHANES III equations? 
Defaults to \code{FALSE}.}

\item{JRS}{Logical. Is input data for the JRS equations? 
Defaults to \code{FALSE}.}

\item{diff}{Logical. Is input data for the GLI diffusing capacity equations? 
Defaults to \code{FALSE}.}
}
\value{
Returns a data frame with these four columns plus a column 'agebound', which is
age rounded to the lowest 0.25 of the year.
}
\description{
This function checks the supplied somatometric input and returns a
properly formatted data.frame
}
\keyword{internal}
