% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_get_form_responses.R
\name{scto_get_form_responses}
\alias{scto_get_form_responses}
\title{Read form data from a SurveyCTO server and convert to long format}
\usage{
scto_get_form_responses(
  auth,
  form_id,
  id_cols = c("KEY", "formdef_version", "CompletionDate", "SubmissionDate", "starttime",
    "endtime", "review_status", "review_quality"),
  exclude_cols = "instanceID",
  ...
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{form_id}{String indicating id of the form.}

\item{id_cols}{Character vector of data columns to keep in the result, will
be passed as \code{id.vars} to \code{\link[data.table:melt.data.table]{data.table::melt()}}.}

\item{exclude_cols}{Character vector of data columns to exclude from the
result.}

\item{...}{Additional arguments passed to \code{\link[=scto_read]{scto_read()}}.}
}
\value{
A \code{data.table} with one row per response, i.e., one row per form
submission per field. If necessary to avoid ambiguity, columns from the
"survey" part of the form definition are prefixed with \code{field_}, while
columns from the "choices" part of the form definition are prefixed with
\code{choice_}. Original column names from data returned by \code{\link[=scto_read]{scto_read()}} are
in the \code{submission_field_name} column, while corresponding values are in
the \code{field_value} column. Data can be converted back to wide format as
desired using \code{\link[data.table:dcast.data.table]{data.table::dcast()}} or \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}.
}
\description{
This function converts data from \code{\link[=scto_read]{scto_read()}} to long format, then joins
the data with the "survey" and "choices" components of the form metadata.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
responses = scto_get_form_responses(auth, 'my_form')
}

}
