% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{info}
\alias{info,SsimLibrary-method}
\title{Retrieves information about a library}
\usage{
info(ssimLibrary)

\S4method{info}{SsimLibrary}(ssimLibrary)
}
\arguments{
\item{ssimLibrary}{\code{\link{SsimLibrary-class}} object}
}
\value{
Returns a \code{data.frame} with information on the properties of the SsimLibrary
object.
}
\description{
Retrieves some basic metadata about a SsimLibrary: Name, Owner, Last Modified,
Size, Read Only, Data files, Publish files, Temporary files, Backup files,
and Use conda.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Get information about SsimLibrary  
info(myLibrary)
}

}
