% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_html}
\alias{set_formatter_html}
\title{Set HTML formatter}
\usage{
set_formatter_html(widget, column, hoz_align = c("left", "center", "right"))
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set HTML formatter
}
\examples{
data <- data.frame(
  id = c(1, 2, 3, 4, 5, 6, 7),
  text_style = c(
    "<i>Italic</i>",
    "<b>Bold</b>",
    "<span style='color: green'>Green</span>",
    "<del>Deleted</del>",
    "<small>Small</small>",
    "H<sub>2</sub>O",
    "x<sup>2</sup>"
  )
)

tabulator(data, width = 400) |>
  set_formatter_html("text_style")
}
