% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffReader.R
\name{getTIC}
\alias{getTIC}
\title{Extract a total ion chromatogram (TIC) from a Wiff file}
\usage{
getTIC(wiff, index = 1)
}
\arguments{
\item{wiff}{A wiff reader object of class \code{rtmsWiffReader}}

\item{index}{The particular run within the wiff file for which the TIC
should be extracted.  Defaults to 1, the first (and often only) run.}
}
\value{
A data frame containing the TIC data (see Details)
}
\description{
Extract a total ion chromatogram (TIC) from a Wiff file
}
\details{
The total ion chromatogram data in a .wiff file contains data for every
moment at which the EchoMS took a measurement. Each measurement is
represented by a single row in the returned data frame, with the following
four values:
\itemize{
\item \code{time}: The time (in seconds) after the beginning of the run at which the
measurement was taken
\item \code{intensity}: The total ion intensity across all masses measured
\item \code{full}: Either 0 (indicating data is stored as a discrete set of targeted
intensities) or 1 (indicating the data is stored as a compressed full
spectrum)
\item \code{offset}: The binary offset within this run's data block in the associated
.wiff.scan file at which this measurement's raw data can be found
\item \code{size}: The size (in bytes) of this measurment's raw data in the associated
.wiff.scan file.
}
}
\examples{
wiff <- exampleWiff

tic <- getTIC(wiff)

# Plot the first 60 seconds of the total ion chromatgram using [ggplot2]
ggplot2::ggplot(tic,ggplot2::aes(x=time,y=intensity))+
	ggplot2::geom_line(color="red")+
	ggplot2::xlim(0,60)
}
