% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffReader.R
\name{measureEjections}
\alias{measureEjections}
\alias{measureEjections.rtmsWiffReader}
\alias{measureEjections.default}
\title{Measure total ion chromatogram peaks to estimate ejection time}
\usage{
measureEjections(
  wiff,
  efficientPath = TRUE,
  center = 3,
  guess = NULL,
  index = 1,
  shots = NULL
)

\method{measureEjections}{rtmsWiffReader}(
  wiff,
  efficientPath = TRUE,
  center = 3,
  guess = NULL,
  index = 1,
  shots = NULL
)

\method{measureEjections}{default}(
  wiff,
  efficientPath = TRUE,
  center = 3,
  guess = NULL,
  index = 1,
  shots = NULL
)
}
\arguments{
\item{wiff}{Either an ojbect of class \code{rtmsWiffReader}, or a data frame
representing a full EchoMS total ion chromatogram as extracted by \code{\link[=getTIC]{getTIC()}}
or \code{\link[=getAllTIC]{getAllTIC()}}}

\item{efficientPath}{If \code{TRUE}, the extraction proceeds under the assumption
that shots were fired from the wells named in \code{shots} using the "efficient"
method of the EchoMS, which proceeds left to right across odd rows (A, C, E,
etc.) and right to left across even rows (B, D, F, etc.). If \code{FALSE}, shots
are assumed to be fired from left to right across all rows}

\item{center}{A guess at the timing (in seconds) between EchoMS shots.  Most
runs are 3 seconds apart, but the EchoMS does permit a fast mode.  If a fast
mode is used, 0.3 seconds should be added to fast mode timing, as the Echo
requires those 0.3 to eject a droplet}

\item{guess}{If included, used as the guess for the timing of the first
shot.  If desired this can usually be estimated visually from a plot of the
total ion chromatogram intensity.  Actual shot timing will still be
optimized to align with TIC intensities.  If \code{NULL} (the default), the
function will guess at the timing of the first shot based on existing runs.}

\item{index}{The particular run within the wiff file for which the TIC
should be extracted.  Defaults to 1, the first (and often only) run.}

\item{shots}{A list of shot names as extracted by \code{\link[=getWiffShots]{getWiffShots()}}; each
name should begin with an alphanumeric well name (e.g. "A01", "B7", "F15")
and may contain the string \code{"Marker"} to indicate the well was used as a
marker.}
}
\value{
A data frame of measured ejections (see Details)
}
\description{
Measure total ion chromatogram peaks to estimate ejection time
}
\details{
The function assumes equally timed ejections, approximately \code{center} seconds
apart, can be found in the total ion chromatogram. Once the timing of these
peaks is selected, the chromatogram is analyzed to locate the boundaries of
these peaks, using baseline noise or local minima to draw these boundaries.
The function returns a data frame with one row for each peak, with the
following columns:
\itemize{
\item \code{shotorder}: The order within the run in which the peaks appeared
\item \code{shot}: The full shot name found in \code{shots}
\item \code{marker}: \code{TRUE} if the shot is indicated as coming from a marker well
\item \code{well}: The standard alphanumeric well name found in the shot name
\item \code{time}: The time (in seconds) after the beginning of the run at which the
peak is expected to reach its maximum
\item \code{minTime}: The time (in seconds) after the beginning of the run at which
the peak is measured to begin
\item \code{maxTime}: The time (in seconds) after the beginning of the run at which
the peak is measured to end
\item \code{area}: The total area (in counts, as intensity is counts per second and
the extend of the peak is measured in seconds) of the peak
\item \code{height}: The maximum height of the peak (in counts per second)
\item \code{width}: The total width of the peak (in seconds)
\item \code{halfWidth}: The width of the peak at half of its maximum intensity (in
seconds)
}
}
\examples{
wiff <- exampleWiff

# Works if file is run with 3 seconds between peaks and shots are fired
# from wells in the efficient "back-and-forth" path
ejections <- measureEjections(wiff)
}
