% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffReader.R
\name{newWiffReader}
\alias{newWiffReader}
\title{Open a Sciex EchoMS wiff File for Reading}
\usage{
newWiffReader(wiffFile, wiffScanFile = NULL)
}
\arguments{
\item{wiffFile}{A valid file path to the Sciex data file (extension .wiff)
containing the metadata for one or more EchoMS runs}

\item{wiffScanFile}{An optional file path the the Sciex scan file (extension
.wiff.scan) containing the full raw EchoMS data}
}
\value{
An object of class \code{rtmsWiffReader} (see Details)
}
\description{
Open a Sciex EchoMS wiff File for Reading
}
\details{
The reader object produced by this function is of class \code{rtmsWiffReader},
and contains the information necessary to extract more detailed data from
this file and the associated .wiff.scan file.  It contains the following
fields:
\itemize{
\item \code{wiff}: The path to the .wiff file being used
\item \code{wiffScan}: If given, the path of the associated .wiff.scan file. Some but
not all functions require this file; this will be specified in their
documentation.
\item \code{cfbf}: A list of values used to parse the .wiff file's internal CFBF
structure
\item \code{samples}: The "sample" list for the .wiff file.  It is important to note
that these are actually different \emph{runs} whose data have been stored in one
file.  Contains data on the specific masses measured in each run.
}
}
