% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rules}
\alias{rules}
\title{Create a list of rules}
\usage{
rules(..., .prefix = "._.")
}
\arguments{
\item{...}{Bare expression(s) with \code{.} as input.}

\item{.prefix}{Prefix to be added to function names.}
}
\description{
\code{rules()} is a function designed to create input for \code{.funs} argument of
scoped \code{dplyr} "mutating" verbs (such as
\link[dplyr:summarise_all]{summarise_all()} and
\link[dplyr:mutate_all]{transmute_all()}). It converts bare expressions
with \code{.} as input into formulas and repairs names of the output.
}
\details{
\code{rules()} repairs names by the following algorithm:
\itemize{
\item Absent names are replaced with the \code{'rule__{ind}'} where \code{{ind}} is the
index of function position in the \code{...} .
\item \code{.prefix} is added at the beginning of all names. The default is \code{._.} . It
is picked for its symbolism (it is the Morse code of letter 'R') and rare
occurrence in names. In those rare cases it can be manually changed but
this will not be tracked further. \strong{Note} that it is a good idea for
\code{.prefix} to be \link[=make.names]{syntactic}, as \code{dplyr} will force tibble
names to be syntactic. To check if string is "good", use it as input to
\code{make.names()}: if output equals that string than it is a "good" choice.
}
}
\examples{
# `rules()` accepts bare expression calls with `.` as input, which is not
# possible with advised `list()` approach of `dplyr`
dplyr::summarise_all(mtcars[, 1:2], rules(sd, "sd", sd(.), ~ sd(.)))

dplyr::summarise_all(mtcars[, 1:2], rules(sd, .prefix = "a_a_"))

# Use `...` in `summarise_all()` to supply extra arguments
dplyr::summarise_all(data.frame(x = c(1:2, NA)), rules(sd), na.rm = TRUE)
}
