% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_calc.R
\name{prob_calc}
\alias{prob_calc}
\title{Calculates player probabilities given players' game statistics.}
\usage{
prob_calc(playerData)
}
\arguments{
\item{playerData}{data frame of the players statistics (details below)}
}
\value{
a dataframe of the players' probabilities for W, S, D, TR, HR, O, SBA, and SB
}
\description{
Uses player statistics to calculate the probability of six
    possible at bat outcomes (walk, single, double, triple, homerun, or out).
    Also estimates the probability of a player attempting a steal (SBA) and
    succeeding in an attempted steal (SB).  Player game statistics are 
    commonly available on team's public webpages.
}
\details{
The \code{playerData} data frame must contain the following columns 
    of player statistics:
    \itemize{
        \item Name: player name
        \item Number: player number
        \item AB: at bats
        \item BB: walks
        \item HBP: hit by pitch
        \item H: hits
        \item 2B: doubles
        \item 3B: triples
        \item HR: homeruns
        \item ATT: attempted steals
        \item SB: successfully stolen bases
    }
    Plate appearances (PA) are calculated 
    as AB + BB + HBP.  The player probabilities are calculated as:
    \itemize{
        \item Walk probability: W = (BB + HBP) / (PA) 
        \item Single probability: S = (H - (2B + 3B + HR)) / (PA) 
        \item Double probability: D = 2B / PA
        \item Triple probability: TR = 3B / PA
        \item Home Run probability: HR = HR / PA
        \item Out probability: O = (PA - (H + BB + HBP)) / PA
    }
    Probabilities calculated from limited at bats will not be very useful.  Note, 
    this function does not assign TRUE/FALSE values for fast players.  These may
    be manually assigned or will be assigned based on SBA probability when \code{chain} 
    or \code{sim} functions are called.
    
    SBA (Stolen Base Attempt) is the probability a player will attempt to steal given they
    are on first base and there is no runner on second. As a default, we estimate a player's
    SBA probability using a rough thresholding rule based on the team's overall SB probability 
    and the player's SB probability.  Essentially, we group the players into three categories: 
     \itemize{
        \item Almost Always Attempt to Steal Group: These players receive the SBA  probability of 
             the team's overall SB probability which is calculated as (Team's total # of SB)/(Team's total # of SBA)
        \item 50/50 Attempt to Steal Group: These players receive SBA  probability of 0.50
        \item Never Attempt to Steal Group: These players receive SBA  probability of 0.0
    }
    We recommend reviewing these default probabilities before proceeding with run expectancy
    calculations.
}
\examples{
probs <- prob_calc(wku_stats)   # probs corresponds to wku_probs

}
