% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_schedule}
\alias{load_schedule}
\title{Load cleaned schedule data from the volleydata repository.}
\usage{
load_schedule(league = NULL, seasons = NULL)
}
\arguments{
\item{league}{A string specifying which of "mlv", "lovb", or "au" to load data for.}

\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.

\if{html}{\out{<div class="sourceCode">}}\preformatted{           All years must be 2023 or later.
}\if{html}{\out{</div>}}}
}
\value{
\tabular{ll}{
   Column Name \tab Type \cr
   season \tab int \cr
   date \tab chr \cr
   home_team \tab chr \cr
   away_team \tab chr \cr
   home_team_set_wins \tab int \cr
   away_team_set_wins \tab int \cr
   result \tab chr \cr
   match_id \tab int \cr
   phase \tab chr \cr
   league \tab chr \cr
}
}
\description{
Load cleaned schedule data from the volleydata repository.
}
\examples{
try({load_schedule("mlv", 2024)})
}
