\name{merging.segments}
\alias{merging.segments}
\title{
Merge Adjacent Segments
}
\description{
It is an option to merge adjacent segments, for which the median values 
in either or both log2ratio and log2mBAF dimensions are not substantially 
different. For WGS and SNP array, it is recommended to do so.
}
\usage{
merging.segments(data, segs.stat, use.null.data = TRUE, 
               N = 1000, maxL = NULL, merge.pvalue.cutoff = 0.05, 
               do.manual.baseline=FALSE,
               log2mBAF.left=NULL, log2mBAF.right=NULL, 
               log2ratio.bottom=NULL, log2ratio.up=NULL,
               seed = NULL, 
               verbose = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{a data frame containing log2ratio and log2mBAF data generated 
  	by \code{\link{cnv.data}}.
}
  \item{segs.stat}{a data frame containing segment locations and summary statistics 
  	resulting from \code{\link{joint.segmentation}}.
}
  \item{use.null.data}{logical. If only data for probes located in normal copy 
  	segments to be used for bootstrapping. Default is \code{TRUE}. If a more 
  	aggressive merging is needed, it can be switched to \code{FALSE}.
}
  \item{N}{the number of replicates drawn by bootstrap.
}
  \item{maxL}{integer. The maximum length in terms of number of probes a bootstrapped segment
  	may span. Default is \code{NULL}. If \code{NULL}, It will be automatically specified 
  	as 1/100 of the number of data points.
}
  \item{merge.pvalue.cutoff}{a p-value cut-off for merging. If the empirical p-value is 
  	greater than the cut-off value, the two adjacent segments under consideration will 
  	be merged.
}
  \item{do.manual.baseline}{logical. If baseline adjustment to be done manually. Default is \code{FALSE}.
}
  \item{log2mBAF.left, log2mBAF.right, log2ratio.bottom, log2ratio.up}{
  	left, right, bottom and up boundaries to be specified manually by a visual inspectio of 
  	2-D diagnosis plot generated by \code{\link{diagnosis.cluster.plot}}. 
  	These parameters are active when \code{do.manual.baseline=TRUE}.
}
  \item{seed}{integer. Random seed can be set for reproducibility of results.
}
  \item{verbose}{logical. If more details to be output. Default is \code{TRUE}.
}
}
%% \details{
%%  ~~ If necessary, more details than the description above ~~
%% }
\value{
A data frame with the same columns as the one generated by 
\code{\link{joint.segmentation}}.
}
%% \references{
%% ~put references to the literature/web site here ~
%% }
\author{
Zhongyang Zhang <zhongyang.zhang@mssm.edu>
}
%% \note{
%%  ~~further notes~~
%% }

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{cnv.data}}, \code{\link{joint.segmentation}}
}
\examples{
data(seq.data)
data(seq.segs)

\dontrun{
seq.segs.merge <- merging.segments(data=seq.data, segs.stat=seq.segs, 
                                 use.null.data=TRUE,
                                 N=1000, maxL=2000, 
                                 merge.pvalue.cutoff=0.05, verbose=TRUE)
}

## how the results look like
data(seq.segs.merge)
head(seq.segs.merge) 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ merge }
\keyword{ segmentation }
