% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar.normal.R
\name{sar.normal}
\alias{sar.normal}
\title{Small Area Estimation under Spatial Simultaneous Autoregressive (SAR) Model and Normal Distribution using Hierarchical Bayesian Method}
\usage{
sar.normal(
  formula,
  vardir,
  proxmat,
  iter.update = 3,
  iter.mcmc = 2000,
  thin = 1,
  burn.in = 1000,
  coef,
  var.coef,
  data
)
}
\arguments{
\item{formula}{formula that describe the fitted model.}

\item{vardir}{sampling variances of direct estimations.}

\item{proxmat}{\code{D*D} proximity matrix with values in the interval \code{[0,1]} containing the proximities between the row and column domains. The rows add up to \code{1}.}

\item{iter.update}{number of updates with default \code{3}.}

\item{iter.mcmc}{number of total iterations per chain with default \code{2000}.}

\item{thin}{thinning rate, must be a positive integer with default \code{1}.}

\item{burn.in}{number of iterations to discard at the beginning with default \code{1000}.}

\item{coef}{optional vector containing the mean of the prior distribution of the regression model coefficients.}

\item{var.coef}{optional vector containing the variances of the prior distribution of the regression model coefficients.}

\item{data}{the data frame.}
}
\value{
This function returns a list of the following objects:
\item{Est}{A data frame of Small Area mean Estimates using Hierarchical Bayesian Method}
\item{refVar}{Estimated random effect variances}
\item{coefficient}{A data frame with estimated model coefficient}
\item{plot}{Trace, Density, and Autocorrelation Function Plot of MCMC samples}
}
\description{
This function gives small area estimator under Spatial SAR Model and is implemented to variable of interest (y) that assumed to be a Normal Distribution. The range of data is \eqn{(-\infty < y < \infty)}.
}
\examples{
## For data without any non-sampled area
data(sp.norm)       # Load dataset
data(prox.mat)      # Load proximity Matrix

\donttest{result <- sar.normal(y ~ x1 + x2, "vardir", prox.mat, data = sp.norm)}

\donttest{result$Est}          # Small Area mean Estimates
\donttest{result$refVar}       # Estimated random effect variances
\donttest{result$coefficient}  # Estimated model coefficient


# Load library 'coda' to execute the plot
# autocorr.plot(result$plot[[3]])    # Generate ACF Plot
# plot(result$plot[[3]])             # Generate Density and Trace plot



## For data with non-sampled area use sp.normNs


}
