% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat.R
\name{matU}
\alias{matU}
\alias{matTrace}
\alias{matB}
\alias{matBConst}
\alias{matA}
\alias{matAConst}
\alias{matW}
\alias{matWbc}
\alias{matTZ}
\alias{matTZ1}
\title{Matrix constructor functions}
\usage{
matU(.V)

matTrace(x)

matB(y, X, beta, re, matV, psi)

matBConst(y, X, beta, matV, psi)

matA(y, X, beta, matV, psi)

matAConst(y, X, matV, psi)

matW(y, X, beta, re, matV, psi)

matWbc(y, reblup, W, samplingVar, c = 1)

matTZ(.nDomains, .nTime)

matTZ1(.nDomains = 10, .nTime = 10)
}
\arguments{
\item{.V}{(Matrix) variance matrix}

\item{x}{([m|M]atrix) a matrix}

\item{y}{(numeric) response}

\item{X}{(Matrix) design matrix}

\item{beta}{(numeric) vector of regression coefficients}

\item{re}{(numeric) vector of random effects}

\item{matV}{(list of functions) see \code{matVFH} for an example}

\item{psi}{(function) the influence function}

\item{reblup}{(numeric) vector with robust best linear unbiased predictions}

\item{W}{(Matrix) the weighting matrix}

\item{samplingVar}{(numeric) the vector of sampling variances}

\item{c}{(numeric) scalar}

\item{.nDomains}{(integer) number of domains}

\item{.nTime}{(integer) number of time periods}
}
\description{
These functions construct different parts of matrix components. They are used
internally. If you are interested in the weights of a model fitted using
\link{rfh} please try to use \link[saeRobust]{weights.fitrfh} on that object.
}
\details{
\code{matU} computes U. U is the matrix containing only the diagonal
  elements of V. This function returns a list of functions which can be
  called to compute specific transformations of U.

\code{matTrace} computes the trace of a matrix.

\code{matB} computes the matrix B which is used to compute the
  weights in the pseudo linearised representation of the REBLUP.

\code{matBConst} returns a function with one argument, u, to compute
  the matrix B. This function is used internally to compute B in the fixed
  point algorithm.

\code{matA} computes the matrix A which is used to compute the
  weights in the pseudo linearized representation of the REBLUP.

\code{matAConst} returns a function with one argument, beta, to
  compute the matrix A. This function is used internally to compute A in the
  fixed point algorithm for beta.

\code{matW} returns a matrix containing the weights as they are
  defined for the pseudo linear form, such that \code{matW \%*\% y} is the
  REBLUP.

\code{matWbc} returns a matrix containing the weights as they are
  defined for the pseudo linear form, such that \code{matWbc \%*\% y} is the
  bias-corrected REBLUP. \code{c} is a multiplyer for the standard deviation.

\code{matTZ} constructs the Z matrix in a linear mixed model with
  autocorrelated random effects.

\code{matTZ1} constructs the Z1 matrix in a linear mixed model with
  autocorrelated random effects.
}
\examples{
data("grapes", package = "sae")
data("grapesprox", package = "sae")

fitRFH <- rfh(
  grapehect ~ area + workdays - 1,
  data = grapes,
  samplingVar = "var"
)

matV <- variance(fitRFH)

# matU:
matU(matV$V())$U()
matU(matV$V())$sqrt()
matU(matV$V())$sqrtInv()

# matB (and matA + matW accordingly):
matB(
  fitRFH$y,
  fitRFH$x,
  fitRFH$coefficients,
  fitRFH$re,
  matV,
  function(x) psiOne(x, k = fitRFH$k)
)

matBConst(
  fitRFH$y,
  fitRFH$x,
  fitRFH$coefficients,
  matV,
  function(x) psiOne(x, k = fitRFH$k)
)(fitRFH$re)

# construcors for 'Z' in linear mixed models
matTZ(2, 3)
matTZ1(2, 3)
}
\references{
Warnholz, S. (2016): "Small Area Estimaiton Using Robust Extension to Area
Level Models". Not published (yet).
}
