% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{computeStatsForLogrank}
\alias{computeStatsForLogrank}
\title{Computes the sufficient statistics needed to compute 'logrankSingleZ'}
\usage{
computeStatsForLogrank(
  survDataFrame,
  y0Index,
  y1Index,
  timeNow,
  timeBefore,
  survType = "right",
  ...
)
}
\arguments{
\item{survDataFrame}{a 'Surv' object converted to a matrix, then to a data.frame}

\item{y0Index}{vector of integers corresponding to the control group}

\item{y1Index}{vector of integers corresponding to the treatment group}

\item{timeNow}{numeric, current time}

\item{timeBefore}{numeric, previous time}

\item{survType}{character, either "right" or "counting" (left truncated, right censored)}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a list containing at least the following components:
\describe{
  \item{obs0}{number of observations in the control group.}
  \item{obs1}{number of observations in the treatment group.}
  \item{y0}{total number of participants in the control group.}
  \item{y1}{total number of participants in the treatment group.}#'
}
}
\description{
Computes the sufficient statistics needed to compute 'logrankSingleZ'
}
\examples{

data <- generateSurvData(nP = 5,
                         nT = 5,
                         lambdaP = 0.03943723,
                         lambdaT = 0.5*0.03943723,
                         endTime = 40,
                         seed = 2006)

survObj <- survival::Surv(data$time, data$status)

survDataFrame <- as.data.frame(as.matrix(survObj))
y0Index <- which(data$group=="P")
y1Index <- which(data$group=="T")

timeNow <- 4
timeBefore <- 0

computeStatsForLogrank(survDataFrame, y0Index, y1Index, timeNow, timeBefore)

timeNow <- 13
timeBefore <- 4

computeStatsForLogrank(survDataFrame, y0Index, y1Index, timeNow, timeBefore)
}
