% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe2x2Test.R
\name{simulateOptionalStoppingScenarioTwoProportions}
\alias{simulateOptionalStoppingScenarioTwoProportions}
\title{Simulate an optional stopping scenario according to a safe design for two proportions}
\usage{
simulateOptionalStoppingScenarioTwoProportions(safeDesign, M, thetaA, thetaB)
}
\arguments{
\item{safeDesign}{a 'safeDesign' object obtained through \code{\link{designSafeTwoProportions}()}.}

\item{M}{integer, the number of data streams to sample.}

\item{thetaA}{Bernoulli distribution parameter in group A}

\item{thetaB}{Bernoulli distribution parameter in group B}
}
\value{
list with the simulation results of the safe test under optional stopping with the following
components:

\describe{
  \item{powerOptioStop}{Proportion of sequences where H0 was rejected}
  \item{nMean}{Mean stopping time}
  \item{probLessNDesign}{Proportion of experiments stopped before nBlocksPlan was reached}
  \item{lowN}{Minimum stopping time}
  \item{eValues}{All achieved E values}
  \item{allN}{All stopping times}
  \item{allSafeDecisions}{Decisions on rejecting H0 for each M}
  \item{allRejectedN}{Stopping times of experiments where H0 was rejected}
}
}
\description{
Simulate an optional stopping scenario according to a safe design for two proportions
}
\examples{
balancedSafeDesign <- designSafeTwoProportions(na = 1,
                                               nb = 1,
                                               nBlocksPlan = 30)
optionalStoppingSimulationResult <- simulateOptionalStoppingScenarioTwoProportions(
  safeDesign = balancedSafeDesign,
  M = 1e2,
  thetaA = 0.2,
  thetaB = 0.5
)
}
