% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safetensors.R
\name{safe_load_file}
\alias{safe_load_file}
\title{Safe load a safetensors file}
\usage{
safe_load_file(path, ..., framework)
}
\arguments{
\item{path}{Path to the file to load}

\item{...}{Additional framework dependent arguments to pass to the tensor creation function.}

\item{framework}{Framework to load the data into. Currently supports "torch" and "pjrt"}
}
\value{
A list with tensors in the file. The \code{metadata} attribute can be used
to find metadata the metadata header in the file.
}
\description{
Loads an safetensors file from disk.
}
\examples{
if (rlang::is_installed("torch") && torch::torch_is_installed()) {
  tensors <- list(x = torch::torch_randn(10, 10))
  temp <- tempfile()
  safe_save_file(tensors, temp)
  safe_load_file(temp, framework = "torch")
}

}
\seealso{
\link{safetensors}, \code{\link[=safe_save_file]{safe_save_file()}}
}
