% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safetyGraphicsApp.R
\name{safetyGraphicsApp}
\alias{safetyGraphicsApp}
\title{Run the core safetyGraphics App}
\usage{
safetyGraphicsApp(
  domainData = list(labs = safetyData::adam_adlbc, aes = safetyData::adam_adae, dm =
    safetyData::adam_adsl),
  meta = NULL,
  charts = NULL,
  mapping = NULL,
  autoMapping = TRUE,
  filterDomain = "dm",
  chartSettingsPaths = NULL,
  runNow = TRUE
)
}
\arguments{
\item{domainData}{named list of data.frames to be loaded in to the app. Sample AdAM data from the safetyData package used by default}

\item{meta}{data frame containing the metadata for use in the app. If no metadata is provided, metatdata is generated by \code{makeMeta()}.}

\item{charts}{list of charts in the format produced by safetyGraphics::makeChartConfig()}

\item{mapping}{list specifying the initial mapping values for each data mapping for each domain (e.g. list(aes= list(id_col='USUBJID', seq_col='AESEQ')).}

\item{autoMapping}{boolean indicating whether the app should attempt to automatically detect data standards and generate mappings for the data provided. Values specified in the \code{mapping} parameter overwrite automatically generated mappings when both are found. Defaults to true.}

\item{filterDomain}{domain used for the data/filter tab. Demographics ("\code{dm}") is used by default. Using a domain that is not one record per participant is not recommended.}

\item{chartSettingsPaths}{path(s) where customization functions are saved relative to your working directory. All charts can have initialization (e.g. myChart_Init.R) and static charts can have charting functions (e.g. myGraphic_Chart.R).   All R files in this folder are sourced and files with the correct naming convention are linked to the chart. See the Custom Charts vignette for more details.}

\item{runNow}{Should the shiny app object created be run directly? Helpful when writing  functions to dispatch to shinyapps, rsconnect, or shinyproxy.}
}
\description{
Run the core safetyGraphics App
}
