#'  forfeitures

#' A data set containing list of forfeitures for those who were condemned, escaped,
#' and stood mute during trial.
#' @format  A data frame with 30 rows and 6 variables with the name Person_condemned:
#' \describe{
#'  \item{legal_status}{Legal status at time of forfeiture}
#'  \item{Name}{Name of those who were condemned during the trial}
#'  \item{marital_status}{The marital status for females }
#'  \item{forfeiture}{The evidence that a forfeiture was ordered}
#'  \item{reversed}{Was the declaration of the attainders was reversed }
#'   }
#'
#'  The source has some Key Tables which are:
#'  for the 1703 and 1711 acts reversing some of the witchcraft attainder see
#'  Commonwealth of Massachusetts, the Act and Resolver, Public and Private,
#'  of the providence of the Massachusetts Bay, 21 vols. (Boston, 1869-1922), VI, 49-50
#'  (1703 act), VI, 71-72 (1711 act).
#'  SWP-Paul Boyer and Stephen Nissenbain, eds., The Salem Witchcraft Papers;
#'  Verbian Transcript of the Legal Documents of the Salem Witchcraft
#'  Outbreak of 1692, 3 vols. (New York, 1977).
#'  Calef-Robert Calef, More Wonders of the Invisible World (London, 1700),
#'  excerpted in George L. Burr, ed., Narratives of the Witchcraft Cases,
#'   1684-1706 (New York, 1914), 293-393.
#'  Brattle-Thomas Brattle, "Letter," Oct. 8, 1692, in Burr, ed., Narratives, 169-190.
#'  Hale-John Hale, A modest Inquiry Into the Nature of Witchcraft
#'  (Boston, 1702), in Burr, Narratives, 399-432.
#'  Gage-Thomas Gage, the History of Rowley (Boston, 1840).

#' @source {Brown, David C. “The Forfeitures at Salem, 1692.” The William and Mary Quarterly,#' vol. 50, no. 1, 1993, pp. 85–111. JSTOR, www.jstor.org/stable/2947237?seq=1, 10.2307/2947237}

"forfeitures"
