% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixTypos.R
\name{fixTypos}
\alias{fixTypos}
\title{Fix typos in VADIR dataset}
\usage{
fixTypos(data, old, new = NULL, var = "RANK_CD")
}
\arguments{
\item{data}{VADIR dataset}

\item{old}{Character vector containing typos}

\item{new}{Character vector in the same order as \code{old}, containing
corresponding values to fix typos to.}

\item{var}{Variable name for which typos should be corrected}
}
\value{
VADIR dataset with typos corrected
}
\description{
If there are known typos, the correct values of those incorrect responses can
be provided and fixed across the dataset.
}
\examples{
data <- fixTypos(data = VADIR_fake, old = c('CW02', 'CW0-2', 'PV1'),
                 new = c('CWO2', 'CWO2', 'PVT'), var = 'RANK_CD')
}
