% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop-misc.R, R/breaks-misc.R, R/tab.R
\name{chop_fn}
\alias{chop_fn}
\alias{brk_fn}
\alias{tab_fn}
\title{Chop using an existing function}
\usage{
chop_fn(
  x,
  fn,
  ...,
  extend = NULL,
  left = TRUE,
  close_end = TRUE,
  raw = NULL,
  drop = TRUE
)

brk_fn(fn, ...)

tab_fn(
  x,
  fn,
  ...,
  extend = NULL,
  left = TRUE,
  close_end = TRUE,
  raw = NULL,
  drop = TRUE
)
}
\arguments{
\item{x}{A vector.}

\item{fn}{A function which returns a numeric vector of breaks.}

\item{...}{Further arguments to \code{fn}}

\item{extend}{Logical. If \code{TRUE}, always extend breaks to \verb{+/-Inf}. If \code{NULL},
extend breaks to \code{min(x)} and/or \code{max(x)} only if necessary. If \code{FALSE}, never
extend.}

\item{left}{Logical. Left-closed or right-closed breaks?}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}

\item{raw}{Logical. Use raw values in labels?}

\item{drop}{Logical. Drop unused levels from the result?}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_fn()} is a convenience wrapper: \code{chop_fn(x, foo, ...)}
is the same as \code{chop(x, foo(x, ...))}.
}
\examples{

if (requireNamespace("scales")) {
  chop_fn(rlnorm(10), scales::breaks_log(5))
  # same as
  # x <- rlnorm(10)
  # chop(x, scales::breaks_log(5)(x))
}

}
\seealso{
Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_spikes}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
