% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{.write_metadata_cache}
\alias{.write_metadata_cache}
\title{Write metadata cache file to disk}
\usage{
.write_metadata_cache(folder, .dry = FALSE)
}
\arguments{
\item{folder}{Route to the folder containing the data. Default to working
directory}

\item{.dry}{Dry run. Metadata is loaded and read, but no cache is written}
}
\value{
A list of tibbles with the five metadata classes (site, stand,
  species, plant and environmental)
}
\description{
Load all sites, read the metadata and write it to disk to cache the
info for easy and fast access
}
\details{
Load all data in memory to collect metadata info can be resource limiting.
For easy and quick access to metadata, this function stores an .RData file
in the specified folder along the data with all the metadata preloaded.
}
\examples{
# Let's access the data in "folder". This typically is the folder where the
# sapflow data at the desired unit level is (i.e. "RData/plant"), but in this
# example we will create a temporal folder with some data to test the function
folder <- tempdir()
save(ARG_TRE, file = file.path(folder, 'ARG_TRE.RData'))
save(ARG_MAZ, file = file.path(folder, 'ARG_MAZ.RData'))

# lets create the metadata cache file
sapfluxnetr:::.write_metadata_cache(folder, .dry = FALSE)#' 
file.exists(file.path(folder, '.metadata_cache.RData')) # TRUE

}
\keyword{internal}
