% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofilePro.R
\name{snowprofilePro}
\alias{snowprofilePro}
\title{Construct snowprofile object from PRO file}
\usage{
snowprofilePro(
  Filename,
  ProfileDate = NA,
  tz = "UTC",
  remove_soil = TRUE,
  consider_SH_surface = TRUE,
  suppressWarnings = FALSE
)
}
\arguments{
\item{Filename}{path to pro file}

\item{ProfileDate}{read specific profiles from file either by individual date or a vector of dates (default = NA will read all profiles)}

\item{tz}{time zone (default = 'UTC')}

\item{remove_soil}{if soil layers are present in PRO file, remove them from snowprofile objects?}

\item{consider_SH_surface}{boolean switch to read the special PRO field 0514--SH at surface (this will produce NA for many unknown layer properties except gsize, density, hardness, gtype, height)}

\item{suppressWarnings}{boolean switch}
}
\value{
a single snowprofile object or a snowprofileSet (list of multiple snowprofile objects) depending on whether multiple or single dates are being read. If several ProfileDates are being given,
but only one of the dates contains snow, a snowprofileSet of length 1 is returned.
}
\description{
Read .pro files from SNOWPACK model output
}
\details{
Several SNOWPACK model output formats exist see \href{https://snowpack.slf.ch/doc-release/html/snowpackio.html}{SNOWPACK documentation}

Definitions of PRO files are provided at \href{https://snowpack.slf.ch/doc-release/html/pro_format.html}{https://snowpack.slf.ch/doc-release/html/pro_format.html} and an example file is available at \href{https://run.niviz.org/?file=resources\%2Fexample.pro}{niViz}

PRO files typically contain profiles from the same station at multiple time steps. If a specific \code{ProfileDate} is provided a single snowprofile object is returned (search available dates with \code{scanProfileDates}), otherwise all profiles are read and a list of snowprofile objects is returned.
}
\examples{

## Path to example pro file
Filename <- system.file('extdata', 'example.pro', package = 'sarp.snowprofile')

## Download example pro file from niViz
#Filename <- tempfile(fileext = '.pro')
#download.file('https://niviz.org/resources/example.pro', Filename)

## Scan dates in file
Dates <- scanProfileDates(Filename)
print(Dates)

## Read a single profile by date and plot
ProfileDate <- Dates[3]
Profile <- snowprofilePro(Filename, ProfileDate = ProfileDate)
plot(Profile)

## Read entire time series and plot
Profiles <- snowprofilePro(Filename)
plot(Profiles, main = 'Timeseries read from example.pro')

## Read several specific dates and plot
specificDates <- Dates[2:3]
Profiles <- snowprofilePro(Filename, ProfileDate = specificDates)
plot(Profiles)
}
\seealso{
\link{snowprofilePrf}, \link{scanProfileDates}, \link{snowprofileSno}
}
\author{
shorton, dmauracher
}
