% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writePro.R
\name{writePro}
\alias{writePro}
\title{Write snowprofileSet to a PRO file}
\usage{
writePro(
  profiles,
  filename,
  meta = NaN,
  header_comment = "time of creation and SNOWPACK version unknown"
)
}
\arguments{
\item{profiles}{\link{snowprofileSet} object to write.}

\item{filename}{output file path ending in \code{.pro}.}

\item{meta}{optional profile metadata (defaults to \code{summary(profiles, fast = TRUE)} when omitted).}

\item{header_comment}{character string added to the file header.}
}
\value{
Writes a PRO file to disk; returns \code{NULL} invisibly.
}
\description{
Write SNOWPACK PRO files from a \link{snowprofileSet}.
}
\examples{

## Path to example pro file
Filename <- system.file('extdata', 'example.pro', package = 'sarp.snowprofile')

## Read entire time series and plot
Profiles <- snowprofilePro(Filename)
plot(Profiles, main = 'Timeseries read from example.pro')

## Write to file
tmppath = tempfile(pattern = "written_", fileext = ".pro")
writePro(Profiles, tmppath)

## Re-read from tempfile
Profiles2 <- snowprofilePro(tmppath)
(testbool <- all(Profiles[[1]]$layers == Profiles2[[1]]$layers))
if (!testbool) stop("error in writePro re-reading!")
}
\seealso{
\link{snowprofilePro}
}
