% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_from_log.R
\name{models_from_log}
\alias{models_from_log}
\title{model from log}
\usage{
models_from_log(meta, reward_fn = function(x, h) pmin(x, h))
}
\arguments{
\item{meta}{a data frame containing the log metadata
for each set of alpha vectors desired, see
\code{\link{meta_from_log}}}

\item{reward_fn}{a function f(x,a) giving the reward for taking action
a given a system in state x.}
}
\value{
a list with an element for each row in the requested meta data frame,
which itself is a list of the three matrices: transition, observation, and
reward, defining the pomdp problem.
}
\description{
Read model details from log file
}
\details{
assumes transition can be determined by the f_from_log function,
 which is specific to the fisheries example
}
\examples{
\donttest{ # takes > 5s

source(system.file("examples/fisheries-ex.R", package = "sarsop"))
log = tempfile()
alpha <- sarsop(transition, observation, reward, discount, precision = 10,
                log_dir = log)

}
}
