% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{graphsEmp}
\alias{graphsEmp}
\title{Empirical graphs of the tail dependence structure.}
\usage{
graphsEmp(
  sample,
  layout = NULL,
  names = NULL,
  k,
  which = "taildependograph",
  select = NULL,
  simplify = FALSE,
  random = FALSE,
  thick.td = 5,
  thick.ec = 5
)
}
\arguments{
\item{sample}{A \code{(n times d)} matrix.}

\item{layout}{The vertex coordinates as a \code{(d times 2)} matrix. The default is NULL. See also the parameter \code{random}.}

\item{names}{A character vector of length \code{d} which replaces \code{as.character(1:d)} (the default ones).}

\item{k}{An integer smaller or equal to \code{n}.}

\item{which}{A character string: \code{taildependograph} (the default), \code{iecgraph} or  \code{both}.}

\item{select}{If select = NULL (default) all edges are plotted. If select is an integer between 1 and the number of possible pairs of components of sample, then only the select largest edges are plotted.}

\item{simplify}{If select is not NULL, and if a vertex is not associated with one of the selected edges, this vertex is not printed.}

\item{random}{A boolean. `FALSE` (the default): the vertex positions are fixed along a circle when layout is NULL.  `TRUE`: some randomness is applied for positioning the vertices.}

\item{thick.td}{A numeric value for the maximal thickness of edges in \code{taildependograph}. Default value is 5.}

\item{thick.ec}{A numeric value for the maximal thickness of edges in \code{iecgraph}. Default value is 5.}
}
\value{
It returns both (or one among) the empirical tail dependograph and the empirical inverse extremal coefficients graph of the  \code{sample}.

 The empirical tail dependograph represents the pairwise empirical  tail superset importance coefficients, see  Mercadier, C. and Roustant, O. (2019).
 These indices are computed by the function \code{tsicEmp}.
 It measures how much a pair of components (included supersets of this pair of components) is involved in the asymptotic dependence of the sample.

 The empirical Inverse extremal coefficients graph represents empirical pairwise coefficients that estimate \eqn{1-\ell(1_i,1_j,\bold{0})/2}.
}
\description{
Empirical tail dependograph and  empirical inverse extremal coefficients graph of the tail dependence structure on a \code{sample} associated with threshold k.
}
\examples{

## Fix a 8-dimensional asymmetric tail dependence structure
ds8 <- gen.ds(d = 8)

## Generate a 200-sample of Frechet margins Mevlog model associated with ds8
sample8 <- rMevlog(n = 200 , ds = ds8)

## Plot the tail dependograph of ds8
graphs(ds = ds8)

## Its empirical version for k = 20
graphsEmp(sample = sample8, k = 20)

## Its empirical version for k = 20 restricted to the 3 largest edges
graphsEmp(sample = sample8, k = 20, select = 3)

## Plot the Inverse extremal coefficients graph of ds8
graphs(ds = ds8, which = "iecgraph")

## Its empirical version for k = 20
graphsEmp(sample = sample8, k = 20, which = "iecgraph")

## Its empirical version for k = 20 restricted to the 3 largest edges
graphsEmp(sample = sample8, k = 20, which = "iecgraph", select = 3)

## Plot the empirical tail dependograph
## on river discharge data for tributaries
## of the Danube extracted from
##  Asadi P., Davison A.C., Engelke S. (2015).
## “Extremes on river networks.”
## The Annals of Applied Statistics, 9(4), 2023 – 2050.
#NOT RUN dan <- graphicalExtremes::danube$data_clustered
#NOT loc <- as.matrix(graphicalExtremes::danube$info[,c('PlotCoordX', 'PlotCoordY')])
#NOT graphsEmp(dan,  k=50, layout = loc)

}
\references{
Mercadier, C. and Roustant, O. (2019)
The tail dependograph.
\emph{Extremes}, \bold{22}, 343--372.
}
\seealso{
\code{\link[satdad]{ecEmp}}, \code{\link[satdad]{tsicEmp}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
