% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_trans_inc_dens_ce.R
\name{prop_trans_inc_dens_ce}
\alias{prop_trans_inc_dens_ce}
\title{Probability Transform Incidence Density Accounting for Competing Events}
\usage{
prop_trans_inc_dens_ce(data, ce, tau)
}
\arguments{
\item{data}{(\code{data.frame})\cr with columns including
\itemize{
\item \code{time_to_event}: Time to the first AE, death or soft competing event.
\item \code{type_of_event}: 0 for censored, 1 for AE, 2 for death, 3 for soft competing event.
}}

\item{ce}{(\code{number})\cr code for competing event.}

\item{tau}{(\code{number})\cr milestone at which Probability Transform Incidence Density is computed.}
}
\value{
(\code{vector})\cr with the following entries:
\itemize{
\item \code{ae_prob}: Estimated probability of AE.
\item \code{ae_prob_var}: Variance of that estimate.
}
}
\description{
This function calculates the incidence density of both adverse events and specified competing events
observed in \verb{[0, tau]} and then combines and transforms the incidence densities on a probability scale.
Please also refer to formulas (4) and (5) in \insertCite{stegherr_survival_2021;textual}{savvyr}.
}
\examples{
set.seed(123)
dat <- generate_data(n = 5, cens = c(2, 5), haz_ae = 2, haz_death = 3, haz_soft = 5)
prop_trans_inc_dens_ce(dat, ce = 2, tau = 4)
}
\references{
\insertRef{stegherr_survival_2021}{savvyr}
}
