% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scan_pb_perm_cpp}
\alias{scan_pb_perm_cpp}
\title{Calculate the space-time permutation scan statistic.}
\usage{
scan_pb_perm_cpp(
  counts,
  baselines,
  zones,
  zone_lengths,
  store_everything,
  num_mcsim
)
}
\arguments{
\item{counts}{An integer matrix (most recent timepoint in first row).}

\item{baselines}{A matrix with positive entries (most recent timepoint in 
first row).}

\item{zones}{An integer vector (all zones concatenated; locations indexed 
from 0 and up)}

\item{zone_lengths}{An integer vector.}

\item{store_everything}{A boolean.}

\item{num_mcsim}{An integer.}
}
\value{
A list with elements \code{observed} and \code{simulated}, each 
   being a data frame with columns:
   \describe{
     \item{zone}{The top-scoring zone (spatial component of MLC).}
     \item{duration}{The corresponding duration (time-length of MLC).}
     \item{score}{The value of the loglihood ratio statistic (the scan
                  statistic).}
     \item{relrisk_in}{The estimated relative risk inside.}
     \item{relrisk_in}{The estimated relative risk outside.}
   }
}
\description{
Calculate the space-time permutation scan statistic (Kulldorff 2005) and 
Monte Carloo  replicates.
}
\keyword{internal}
