% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{segment.check_subconductance}
\alias{segment.check_subconductance}
\title{Check if segment contains subconductive states}
\usage{
segment.check_subconductance(segment)
}
\arguments{
\item{segment}{The dwells and states table}
}
\value{
True if it contains an conductance other than 0 or 1, False otherwise.
}
\description{
Check if segment contains subconductive states
}
\examples{

# It's more likely that you created states or dwells with some function
states  <-  c(0,    0.2,    0,    1,    0,  0.5,    0,  0.7,    0,    1)
dwells  <-  c(0.1,  1.1,  0.5,  0.2,  1.0,  1.1,  0.6,  1.1,  0.8,  1.1)
my_burst <- segment.create(states, dwells, seg=1, start_time=3.14159, name="example_segment")

segment.check_subconductance(my_burst)

}
