% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_gls.R
\name{replext_gls}
\alias{replext_gls}
\title{Replications and Extension of Generalized Least Squares Simulation}
\usage{
replext_gls(
  n_timepoints_list,
  rho_list,
  iterations,
  n_phases = 2,
  n_IDs = 1,
  betas,
  formula,
  covariate_specs = NULL,
  alpha_level = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{n_timepoints_list}{Numeric vector. The numbers of timepoints per phase
to simulate.}

\item{rho_list}{Numeric vector. The autocorrelation parameters to simulate.}

\item{iterations}{Integer. The number of simulations to run for each combination
of conditions.}

\item{n_phases}{Integer. The number of phases in the design. Default is 2.}

\item{n_IDs}{Integer. The number of subjects (IDs) to simulate. Default is 1.}

\item{betas}{Named numeric vector. The true coefficient values for the model.}

\item{formula}{Formula object. The model formula to be fitted.}

\item{covariate_specs}{List of lists. Specifications for generating covariates.
Each inner list should contain elements 'vars' (variable names), 'dist'
(distribution function name), 'args' (list of distribution parameters), and
optionally 'expr' (a function to generate data).}

\item{alpha_level}{Numeric. The significance level for hypothesis tests. Default
is 0.05.}

\item{verbose}{Logical. If TRUE, print progress messages. Default is FALSE.}
}
\value{
A data frame of class 'replext_gls' containing simulation results, including:
\item{term}{Character. The name of the model term.}
\item{tppp}{Integer. The number of timepoints per phase.}
\item{rho}{Numeric. The autocorrelation parameter.}
\item{success_rate}{Numeric. The proportion of successful model fits.}
\item{mean_estimates}{Numeric. The mean of the estimated coefficients.}
\item{mean_bias}{Numeric. The mean bias of the estimated coefficients.}
\item{se_estimates}{Numeric. The standard error of the estimated coefficients.}
\item{rejection_rates}{Numeric. The proportion of significant hypothesis tests.}
\item{se_rejection_rates}{Numeric. The standard error of the rejection rates.}
\item{mean_rmse}{Numeric. The mean root mean square error of the estimates.}
\item{alpha_level}{Numeric. The significance level used for hypothesis tests.}
\item{iterations}{Integer. The number of iterations performed.}
\item{n_phases}{Integer. The number of phases in the design.}
\item{n_IDs}{Integer. The number of subjects simulated.}
\item{formula}{Character. The model formula used.}
\item{covariate_specs}{Character. The covariate specifications used.}
}
\description{
This function performs multiple simulations of Generalized Least Squares (GLS)
models across various conditions, extending the work of Maric et al. (2014).
It allows for the exploration of different numbers of timepoints per phase and
autocorrelation parameters, providing a comprehensive analysis of model
performance across these conditions.
}
\examples{
results <- replext_gls(
  n_timepoints_list = c(10),
  rho_list = c(0.2),
  iterations = 10,
  betas = c("(Intercept)" = 0, "phase1" = 1),
  formula = y ~ phase
)

}
\references{
Maric, M., de Haan, E., Hogendoorn, S.M., Wolters, L.H. & Huizenga, H.M. (2014).
Evaluating statistical and clinical significance of intervention effects in
single-case experimental designs: An SPSS method to analyze univariate data.
Behavior Therapy. doi: 10.1016/j.beth.2014.09.009
}
