% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sci_figure.R
\name{sci_figure}
\alias{sci_figure}
\title{Create a figure depicting reproducibility/replicability of a set of
scientific experiments}
\usage{
sci_figure(experiments, custom_icons = NULL,
  stage_names = c("Population", "Question", "Hypothesis", "Exp. Design",
  "Experimenter", "Data", "Analysis Plan", "Analyst", "Code", "Estimate",
  "Claim"), hide_stages = NULL, diff = FALSE, showlegend = TRUE,
  cols = c("#D20000", "#007888", "#CDCDCD", "black"),
  leg_text = c("Incorrect", "Different", "Unobserved", "Original"))
}
\arguments{
\item{experiments}{A data frame, which can be initialized with \code{init_experiments()},
whose rownames are the predefined stages of a scientifc experiments, columnnames are
the names of each experiment, and cell values represent the state of each stage
in each experiment (states described below).}

\item{custom_icons}{(optional) A list of bitmap matrices of custom icon images of length 
matching \code{experiments} input. Bitmap icons must be 75 x 75 pixels. See vignette for detailed instructions and specifications.
Default NULL, indicating that default icons will be used.}

\item{stage_names}{Character vector of names of stages. Default names match Patil et. al.
If set to NULL, all names will be suppressed. Use \code{hide_stages} (below) to suppress specific stage names.}

\item{hide_stages}{(optional) A character vector with the names of the stages
in the scientific experiment, i.e. rownames of \code{experiments}, which the user wishes
to suppress from the figure output. The default value of \code{hide_stages} is NULL, indicating
that all stages will be displayed.}

\item{diff}{(optional) A Boolean flag to indicate whether the rendering of the figure should
emphasize the differences between the experiments ("difference mode"). The difference mode uses
a set of four symbols that are semantically close to the scenarios that they are encoding.
The default value is \code{FALSE}.}

\item{showlegend}{Do you want the legend to be shown?}

\item{cols}{colors to use for the specific scenarios when diff = T or custom_icons used.}

\item{leg_text}{text for legend keys corresponding to the specific colors.}
}
\description{
\code{sci_figure} creates a graphical representation of changes in a
a set of subsequent studies or reproduction attempts as compared to an
original study.
}
\note{
For the parameter \code{experiments}, the four values any cell may take
are: \code{observed}, \code{different}, \code{unobserved}, \code{incorrect}.
}
\examples{

# Initialize the default experiments data frame
exps <- init_experiments()
sci_figure(exps)
sci_figure(exps, hide_stages = c("population", "analyst"))

# Do some manual manipulation to the experiments

exps["analyst", "Exp2"] <- "different"
exps["code", c("Exp2", "Exp3")] <- "unobserved"
sci_figure(exps, showlegend = FALSE)

# Create the same figure using the difference mode

sci_figure(exps, diff=TRUE)
too_many = init_experiments(nexp = 30)

testthat::expect_warning({
sci_figure(too_many)
}, "showing the first")

exp2 = exps
exp2[,1] = "bad"
testthat::expect_error({
sci_figure(exp2)
}, "Invalid cell")

}
\seealso{
\code{\link{init_experiments}}
}
