% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{save_all_plots}
\alias{save_all_plots}
\title{Save all plots to files}
\usage{
save_all_plots(
  result,
  prefix = "scm",
  path = NULL,
  width = 10,
  height = 6,
  dpi = 300,
  ...
)
}
\arguments{
\item{result}{Output from run_scm_spillover}

\item{prefix}{File name prefix (default "scm")}

\item{path}{Directory to save plots (required, no default)}

\item{width}{Plot width in inches (default 10)}

\item{height}{Plot height in inches (default 6)}

\item{dpi}{Resolution (default 300)}

\item{...}{Additional arguments passed to plotting functions}
}
\value{
Character vector of saved file paths, returned invisibly.
}
\description{
Save all plots to files
}
\examples{
\dontrun{
  data <- generate_test_data()
  result <- run_scm_spillover(data, treatment_start = 20)
  save_all_plots(result, path = tempdir())
}
}
