% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fn_error}
\alias{fn_error}
\title{Computes error measures between observed and predicted values}
\usage{
fn_error(base, observed_col, predicted_col)
}
\arguments{
\item{base}{input dataframe}

\item{observed_col}{column / field name of the observed event}

\item{predicted_col}{column / field name of the predicted event}
}
\value{
An object of class "fn_error" is a list containing the following components:

\item{mean_abs_error}{mean absolute error between observed and predicted value}

\item{mean_sq_error}{mean squared error between observed and predicted value}

\item{root_mean_sq_error}{root mean squared error between observed and predicted value}
}
\description{
The function takes the input dataframe with observed and predicted columns and computes mean absolute error, mean squared error and root mean squared error terms.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
data$Y_pred <- sample(0:1,size=nrow(data),replace=TRUE)
fn_error_list <- fn_error(base = data,observed_col = "Y",predicted_col = "Y_pred")
fn_error_list$mean_abs_error
fn_error_list$mean_sq_error
fn_error_list$root_mean_sq_error
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
