% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-symbols.R
\name{parse_cost}
\alias{parse_cost}
\title{Parse mana costs}
\usage{
parse_cost(cost)
}
\arguments{
\item{cost}{The mana string to parse. For more information, see details.}
}
\value{
A data frame with 1 row and the following columns:
\itemize{
\item \code{cost} [chr]: The normalized cost, with correctly-ordered and wrapped
mana symbols.
\item \code{colors} [list]: The colors of the given cost.
\item \code{cmc} [dbl]: The converted mana cost. If you submit Un-set mana symbols,
this decimal could include fractional parts.
\item \code{colorless} [lgl]: Whether the cost is colorless.
\item \code{monocolored} [lgl]: Whether if the cost is monocolored.
\item \code{multicolored} [lgl]: Whether if the cost is multicolored.
}
}
\description{
Parses the given mana \code{cost} argument and returns Scryfall's interpretation.
}
\details{
The server understands most community shorthand for mana costs (such as \verb{2WW}
for \verb{\{2\}\{W\}\{W\}}). Symbols can also be out of order, lowercase, or have
multiple colorless costs (such as \verb{2\{g\}2} for \verb{\{4\}\{G\}}).

If part of the string could not be understood, the server will return an
error describing the problem.
}
\examples{
\donttest{
# Parse mana costs
parse_cost("2g2")
}

}
\references{
\url{https://scryfall.com/docs/api/card-symbols/parse-mana}
}
