% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDA_2S.R
\name{SDA_2S}
\alias{SDA_2S}
\title{Symmetrized Data Aggregation for two-sample t-test}
\usage{
SDA_2S(dat_I, dat_II, alpha, Sigma_I, Sigma_II, stable = TRUE)
}
\arguments{
\item{dat_I}{a \eqn{n_1} by \eqn{p} data matrix, the first part of data}

\item{dat_II}{a \eqn{n_2} by \eqn{p} data matrix, the second part of data}

\item{alpha}{the FDR level}

\item{Sigma_I}{the covariance matrix of sample 1; if it is missing, it will be estimated
by the glasso package.}

\item{Sigma_II}{the covariance matrix of sample 2; if it is missing, it will be estimated
by the glasso package.}

\item{stable}{If it is TRUE, the sample will be randomly splitted \eqn{B=10} times for stability
performance; otherwise, only single sample splitting is used.}
}
\value{
the indices of the hypotheses rejected
}
\description{
Symmetrized Data Aggregation for two-sample t-test
}
\examples{
p = 100
n = 30
dat_I = matrix(rnorm(n*p),nrow = n)
mu = rep(0, p)
mu[1:10] = 1.5
dat_I = dat_I = rep(1, n)\%*\%t(mu)

dat_II = matrix(rnorm(n*p), nrow = n)
Sigma_I = diag(p)
Sigma_II = diag(p)
out = SDA_2S(dat_I, dat_II, alpha=0.05, Sigma_I, Sigma_II)
print(out)

}
