% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KI_createSdcObj.R
\name{KI_createSdcObj}
\alias{KI_createSdcObj}
\title{Create an sdcMicro Object with LLM Assistance}
\usage{
KI_createSdcObj(
  dat,
  codebook = NULL,
  policy = c("open", "restricted", "confidential"),
  model = "gpt-4",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  info = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data.frame containing the microdata.}

\item{codebook}{Optional path to a codebook file (currently not parsed; placeholder for future use).}

\item{policy}{Data sharing policy context: `"open"` (default), `"restricted"`, or `"confidential"`.}

\item{model}{The LLM model to use (default: `"gpt-4"`).}

\item{api_key}{OpenAI API key, defaulting to the `OPENAI_API_KEY` environment variable.}

\item{info}{Logical; if TRUE, prints the LLM classification result.}

\item{...}{Additional arguments passed to `createSdcObj()`.}
}
\value{
An object of class `sdcMicroObj`.
}
\description{
This function uses a Large Language Model (LLM) to automatically classify variables
in a dataset into quasi-identifiers, sensitive variables, numerical variables, and more,
and passes the result to `createSdcObj()`. It optionally uses a codebook and policy context.
}
\examples{
\dontrun{
data(testdata)
sdc <- KI_createSdcObj(dat = testdata, policy = "open")
sdc
}
}
\author{
Matthias Templ
}
