% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_sdl_methods.R
\name{predict.sdlrm}
\alias{predict.sdlrm}
\title{Predict Method for a Modified Skew Discrete Laplace Regression Fit}
\usage{
\method{predict}{sdlrm}(
  object,
  newdata = NULL,
  type = c("response", "dispersion", "variance", "quantile"),
  at = 0.5,
  na.action = stats::na.pass,
  ...
)
}
\arguments{
\item{object}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{newdata}{optionally, a data frame in which to look for variables
with which to predict. If omitted, the fitted linear predictors are
used.}

\item{type}{the type of prediction required. The default is on the scale of
the response variable \code{("response")}, that is, the fitted values
(fitted means). The alternative \code{"dispersion"} provides the fitted
dispersion parameters, while \code{"variance"} provides the fitted variances. Finally,
the option \code{"quantile"} gives the fitted quantiles in the order
specified via \code{at}.}

\item{at}{the order of the quantile to be predicted if
\code{type = "quantile"}. The default is to predict the median,
that is, \code{at = 0.5}.}

\item{na.action}{function determining what should be done with missing
values in \code{newdata}. The default is to predict \code{NA}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A vector with the required predictions.
}
\description{
Obtains predictions from a fitted modified skew discrete Laplace regression object.
}
\examples{
## Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

## Fit a double model (mode = 1)
fit <- sdlrm(difference ~ group | group, data = pss, xi = 1)

## Fitted values (fitted means)
means <- predict(fit)
means

## Fitted dispersion parameter
phi <- predict(fit, type = "dispersion")
phi

## Fitted variances
vars <- predict(fit, type = "variance")
vars

## Fitted medians
medians <- predict(fit, type = "quantile")
medians

## Fitted third quartiles
quantiles <- predict(fit, type = "quantile", at = 0.75)
quantiles
}
\references{
Medeiros, R. M. R., and Bourguignon, M. (2025). Modified skew discrete Laplace
    regression models for integer valued data with applications to paired samples.
    \emph{Manuscript submitted for publication.}
}
\author{
Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
