% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_sdl_methods.R
\name{summary.sdlrm}
\alias{summary.sdlrm}
\alias{print.summary.sdlrm}
\title{Summarizing a Modified Skew Discrete Laplace Regression Fit}
\usage{
\method{summary}{sdlrm}(object, ...)

\method{print}{summary.sdlrm}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{object}{an object of class \code{"sdlrm"}, a result of a call to \code{\link{sdlrm}}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.sdlrm"}, a result of a call to \code{summary.sdlrm}.}

\item{digits}{a non-null value for digits specifies the minimum number of significant digits to
be printed in values.}
}
\value{
The function \code{summary.sdlrm} returns an object of class \code{"summary.sdlrm"},
    which consists of a list with the following components:
 \describe{
    \item{call}{the original function call, given in \code{object}.}
    \item{mean}{summary statistics for the mean regression structure.}
    \item{dispersion}{summary statistics for the dispersion regression structure.}
    \item{xi}{the specified mode for the model.}
    \item{phi.link}{the link function used for the dispersion parameter model.}
    \item{residuals}{the randomized quantile residuals.}
    \item{pR2}{the pseudo-R2 for integer-valued regression models, as introduced by
        Medeiros and Bourguignon (2025).}
    \item{logLik}{log-likelihood value of the fitted model.}
    \item{AIC, BIC}{Akaike and Bayesian information criteria.}
 }
}
\description{
\code{summary} method for class \code{"sdlrm"}.
}
\examples{
# Data set: pss (for description run ?pss)
barplot(table(pss$difference), xlab = "PSS index difference", ylab = "Frequency")
boxplot(pss$difference ~ pss$group, xlab = "Group", ylab = "PSS index difference")

# Fit with a model only for the mean (mode = 1)
fit0 <- sdlrm(difference ~ group, data = pss, xi = 1)
summary(fit0)

# Fit a double model (mean and dispersion)
fit <- sdlrm(difference ~ group | group, data = pss, xi = 1)
summary(fit)
}
\references{
Medeiros, R. M. R., and Bourguignon, M. (2025). Modified skew discrete Laplace
    regression models for integer valued data with applications to paired samples.
    \emph{Manuscript submitted for publication.}
}
\author{
Francisco F. de Queiroz <\email{felipeq@ime.usp.br}>

Rodrigo M. R. de Medeiros <\email{rodrigo.matheus@ufrn.br}>
}
