% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_problems.R
\name{any_problems}
\alias{any_problems}
\title{Detect problems with the parsing of date/times}
\usage{
any_problems(cap_matrices, dtc, .cutoff_2000 = 68L)
}
\arguments{
\item{cap_matrices}{A list of capture matrices in the sense of the returned
value by \code{\link[=parse_dttm]{parse_dttm()}}.}

\item{dtc}{A list of \code{character} vectors of dates, times or date-times'
components. Typically, this parameter takes the value passed in \code{...} to
a \code{\link[=create_iso8601]{create_iso8601()}} call.}

\item{.cutoff_2000}{An integer value. Two-digit years smaller or equal to
\code{.cutoff_2000} are parsed as though starting with \code{20}, otherwise parsed as
though starting with \code{19}.}
}
\value{
A \code{logical} whose length matches the number of underlying date/times
passed as inputs to \code{\link[=create_iso8601]{create_iso8601()}}, i.e. whose length matches the
number of rows of the capture matrices in \code{cap_matrices}.
}
\description{
\code{\link[=any_problems]{any_problems()}} takes a list of capture matrices (see \code{\link[=parse_dttm]{parse_dttm()}}) and
reports on parsing problems by means of predicate values. A \code{FALSE} value
indicates that the parsing was successful and a \code{TRUE} value a parsing
failure in at least one of the inputs to \code{\link[=create_iso8601]{create_iso8601()}}. Note that this
is an internal function to be used in the context of \code{\link[=create_iso8601]{create_iso8601()}}
source code and hence each capture matrix corresponds to one input to
\code{\link[=create_iso8601]{create_iso8601()}}.
}
\keyword{internal}
