% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_parse_dttm.R
\name{parse_dttm_}
\alias{parse_dttm_}
\alias{parse_dttm}
\title{Parse a date, time, or date-time}
\usage{
parse_dttm_(
  dttm,
  fmt,
  fmt_c = fmt_cmp(),
  na = NULL,
  sec_na = na,
  min_na = na,
  hour_na = na,
  mday_na = na,
  mon_na = na,
  year_na = na
)

parse_dttm(
  dttm,
  fmt,
  fmt_c = fmt_cmp(),
  na = NULL,
  sec_na = na,
  min_na = na,
  hour_na = na,
  mday_na = na,
  mon_na = na,
  year_na = na
)
}
\arguments{
\item{dttm}{A character vector of dates, times or date-times.}

\item{fmt}{In the case of \code{parse_dttm()}, a character vector of parsing
formats, or a single string format in the case of \code{parse_dttm_()}. When a
character vector of formats is passed, each format is attempted in turn
with the first parsing result to be successful taking precedence in the
final result. The formats in \code{fmt} can be any strings, however the
following characters (or successive repetitions thereof) are reserved in
the sense that they are treated in a special way:
\itemize{
\item \code{"y"}: parsed as year;
\item \code{"m"}: parsed as month;
\item \code{"d"}: parsed as day;
\item \code{"H"}: parsed as hour;
\item \code{"M"}: parsed as minute;
\item \code{"S"}: parsed as second.
}}

\item{na, sec_na, min_na, hour_na, mday_na, mon_na, year_na}{A character vector of
alternative values to allow during matching. This can be used to indicate
different forms of missing values to be found during the parsing date-time
strings.}
}
\value{
A character matrix of six columns: \code{"year"}, \code{"mon"}, \code{"mday"},
\code{"hour"}, \code{"min"} and \code{"sec"}. Each row corresponds to an element in
\code{dttm}. Each element of the matrix is the parsed date/time component.
}
\description{
\code{\link[=parse_dttm]{parse_dttm()}} extracts date and time components. \code{\link[=parse_dttm]{parse_dttm()}} wraps around
\code{\link[=parse_dttm_]{parse_dttm_()}}, which is not vectorized over \code{fmt}.
}
\keyword{internal}
