% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ae_aeacnoth_ds_stddisc_covid.R
\name{check_ae_aeacnoth_ds_stddisc_covid}
\alias{check_ae_aeacnoth_ds_stddisc_covid}
\title{Check for COVID-19 AE leading to Study Discon without DS Study Discon}
\usage{
check_ae_aeacnoth_ds_stddisc_covid(
  AE,
  DS,
  covid_terms = c("COVID-19", "CORONAVIRUS POSITIVE")
)
}
\arguments{
\item{AE}{Adverse Events SDTM dataset with variables USUBJID, AEDECOD,
AEACNOT* (can be multiple variables)}

\item{DS}{Disposition SDTM dataset with variables USUBJID, DSSCAT, DSDECOD}

\item{covid_terms}{A length >=1 vector of AE terms identifying COVID-19 (case does not matter)}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Flag if patient has a COVID-19 AE where AE.AEDECOD
matches a COVID-19 preferred term event action of Study Discontinuation
(AE.AEACNOT* includes "DISCONTINUED FROM STUDY") but missing Study Discontinuation
record in DS (DS.DSSCAT includes "STUDY" and "DISCON" and excludes "DRUG" and
"TREATMENT")
}
\examples{

AE <- data.frame(
 USUBJID = 1:5,
 AEDECOD = c("This is a covid AE", "covid-19", "covid-19","Some AE", "CORONAVIRUS POSITIVE" ),
 AEACNOTH=c("SUBJECT DISCONTINUED FROM STUDY",
            "NONE",
            "NONE", 
            "SUBJECT DISCONTINUED FROM STUDY",
            "NONE"),
 AEACNOTH1=c("SUBJECT DISCONTINUED FROM STUDY", 
             "NONE",
             "SUBJECT DISCONTINUED FROM STUDY",
             "NONE", 
             "SUBJECT DISCONTINUED FROM STUDY"),
 AEACNOTH2=c("SUBJECT DISCONTINUED FROM STUDY", 
             "NONE",
             "NONE",
             "SUBJECT DISCONTINUED FROM STUDY",
             "NONE")
)

DS <- data.frame(
 USUBJID = 1:3,
 DSSCAT=c("TREATMENT DISCONTINUATION", 
 "STUDY DISCONTINUATION",
 "STUDY DISCONTINUATION"),
 DSDECOD="DISCON REASON"
)

#expect fail
check_ae_aeacnoth_ds_stddisc_covid(AE,DS)

#use custom terms for identifying covid AEs
check_ae_aeacnoth_ds_stddisc_covid(
  AE,
  DS,
  covid_terms=c("COVID-19", "CORONAVIRUS POSITIVE","THIS IS A COVID AE")
  )

}
\seealso{
Other COVID: 
\code{\link{check_ae_aeacn_ds_disctx_covid}()},
\code{\link{check_dv_ae_aedecod_covid}()},
\code{\link{check_dv_covid}()}
}
\author{
Natalie Springfield
}
\concept{COVID}
\keyword{COVID}
