% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_check.R
\name{run_check}
\alias{run_check}
\title{Run a single check in sdtmchecks package}
\usage{
run_check(
  check,
  fxn_in,
  xls_title,
  pdf_title,
  pdf_subtitle,
  pdf_return,
  verbose
)
}
\arguments{
\item{check}{Check name.}

\item{fxn_in}{Function performing the check.}

\item{xls_title}{Excel title.}

\item{pdf_title}{PDF title.}

\item{pdf_subtitle}{PDF subtitle.}

\item{pdf_return}{Text to display in PDF if check does not run.}

\item{verbose}{Whether to display messages while running}
}
\value{
list with results from the check.
}
\description{
This function runs a single check in the sdtmchecks package. It expects a check name,
the function that performs the check and some info for the pdf and Excel files. It also expects a T/F
value that determines whether to display messages while running. Excluding verbose, the parameters for
this function are usually passed to it by filtering the metads to only contain the row corresponding
to the check of interest, and then assigning each parameter as the contents of the eponymous column
of metads (see example below). This is because this function is mostly run inside of an mcmapply in
the run_all_checks_parallel function, which loops over the checks in the rows of metads.
}
\details{
to look up documentation for the data checks package, please use command ??sdtmchecks
}
\examples{


# Assuming sdtm datasets are in your global environment

 ae <- data.frame(
 USUBJID = 1:5,
 DOMAIN = c(rep("AE", 5)),
 AESEQ = 1:5,
 AESTDTC = 1:5,
 AETERM = 1:5,
 AEDECOD = 1:5,
  AESPID = c("FORMNAME-R:13/L:13XXXX",
             "FORMNAME-R:16/L:16XXXX",
             "FORMNAME-R:2/L:2XXXX",
             "FORMNAME-R:19/L:19XXXX",
             "FORMNAME-R:5/L:5XXXX"),
 stringsAsFactors = FALSE
)

ae$AEDECOD[1] = NA

# Filter sdtmchecksmeta so that only one check is present
metads <- sdtmchecksmeta[sdtmchecksmeta$check=="check_ae_aedecod",] 

run_check(
  check = metads$check,
  fxn_in = metads$fxn_in,
  xls_title = metads$xls_title,
  pdf_title = metads$pdf_title,
  pdf_subtitle = metads$pdf_subtitle,
  pdf_return = metads$pdf_return,
  verbose = FALSE
)
}
\seealso{
Example programs for running data checks
\code{\link{diff_reports}()},
\code{\link{report_to_xlsx}()},
\code{\link{run_all_checks}()}
}
\concept{ex_rpt}
\keyword{ex_rpt}
