% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{impute_pdates}
\alias{impute_pdates}
\title{Impute start or end dates}
\usage{
impute_pdates(dates, ptype, input_sep = "-")
}
\arguments{
\item{dates}{a character vector of partial dates (which could also contain
full dates) in the format YYYY-MM-DD}

\item{ptype}{a string of either \code{"start"} or \code{"end"} indicating whether start
or end dates should be imputed, respectively}

\item{input_sep}{the character that separates date components in \code{dates},
default is \code{"-"}}
}
\value{
a date vector of imputed dates in the format YYYY-MM-DD
}
\description{
Imputes missing date elements for start or end dates. Partial dates should be
in the format \code{"UNKN-UN-UN"} or some combination of those characters and
numbers (ie \code{"2017-UN-UN"}). Dates with no information or dates with a
missing year will be converted to \code{NA}. For start dates, missing days are
assumed to be the first of the month while missing months are assumed to be
January. For end dates, missing days are assumed to be the last day of the
month and missing months are assumed to be December.
}
\examples{
dates <- c(
  "UNKN-UN-UN",
  "2017-UN-UN",
  "2017-02-UN",
  "2017-UN-05",
  "2017-09-03",
  "UNKN-07-14",
  NA
)
impute_pdates(dates, ptype = "start")
impute_pdates(dates, ptype = "end")

}
\seealso{
\code{\link[=reshape_adates]{reshape_adates()}}, \code{\link[=reshape_pdates]{reshape_pdates()}}, \code{\link[=trim_dates]{trim_dates()}},
\code{vignette("Dates")}
}
