% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseasonalize.R
\name{deseasonalize}
\alias{deseasonalize}
\title{Deseasonalize a Time Series Given Seasonal Indices}
\usage{
deseasonalize(data, indices, sl, season_labels = NULL)
}
\arguments{
\item{data}{A numeric vector or `ts` object of original data.}

\item{indices}{A numeric vector (or data.frame column) of seasonal indices of length `sl`.}

\item{sl}{A positive integer giving the seasonal period.}

\item{season_labels}{Optional character vector of length `sl` giving labels for each season.}
}
\value{
A data.frame with columns: Observation (index), Season (label), Original (rounded original data), Deseasonalized (rounded).
}
\description{
Deseasonalize a Time Series Given Seasonal Indices
}
\examples{
data <- as.ts(rnorm(48, mean = 100, sd = 48), frequency = 12)
sl <- 12
si <- SI(data, sl)
deseasonalized <- deseasonalize(data, si$Seasonal_Index, sl)
}
