% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsb.R
\name{ocsb}
\alias{ocsb}
\title{OCSB test}
\usage{
ocsb(
  x,
  method = "OLS",
  augmentations = c(3, 0),
  freq = NA,
  nrun = 1000,
  seed = 123
)
}
\arguments{
\item{x}{time series}

\item{method}{"OLS" or "ML"}

\item{augmentations}{non-seasonal and seasonal order of the augmentations}

\item{freq}{frequency to be tested}

\item{nrun}{number of runs in monte carlo simulation}

\item{seed}{seed for monte carlo simulated based generation of null distribution}
}
\description{
Test for seasonal unit root roots in a time series.
}
\details{
The null hypothesis of the OCSB is that a series contains a seasonal unit root. This is tested by a Dickey-Fuller type regression. The test regression has often to be augmented by autocorrelational terms to ensure white noise of the error terms.

If seasonal lags are included and method='OLS' the test regression is calculated by OLS, so only the seasonal lags are included. If instead of 'OLS' method='ML' a seasonal AR model is calculated, which implies that high-order non-seasonal lags will be indirectly included as well (see Box and Jenkins, 1970). For seasonal augmentations, ML is quite a bit slower than OLS. The run time can be speeded up by reducing the number of runs of the monte carlo simulation (e.g. nrun=100).

Under the null hypothesis the test statistic follows a non-standard distribution and thus needs to be simulated. The number of runs and the seed can be changed.
}
\examples{
teststat <- ocsb(ts(rnorm(70, 10,10), frequency=7), nrun=200)
check_residuals(teststat)
}
\references{
Box, G. and G. Jenkins (1970). Time Series Analysis: Forecasting and Control. San Francisco: Holden-Day.

Osborn D.R., Chui A.P.L., Smith J., and Birchenhall C.R. (1988). Seasonality and the order of integration for consumption, Oxford Bulletin of Economics and Statistics 50(4):361-377.
}
\author{
Daniel Ollech
}
