% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_utils.R
\name{id_paramPos}
\alias{id_paramPos}
\title{Parameter structure setting
Sets the parameters (speciation, extinction and transition) ids. Needed for
ML calculation (\code{\link[=secsse_ml]{secsse_ml()}}).}
\usage{
id_paramPos(traits, num_concealed_states)
}
\arguments{
\item{traits}{vector with trait states for each tip in the phylogeny. The
order of the states must be the same as the tree tips. For help, see
\code{vignette("starting_secsse", package = "secsse")}. When providing a
\code{multiPhylo} set of multiple phylognies, traits should be a list where
each entry in the list corresponds to the matching phylogeny on that
position.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}
}
\value{
A list that includes the ids of the parameters for ML analysis.
}
\description{
Parameter structure setting
Sets the parameters (speciation, extinction and transition) ids. Needed for
ML calculation (\code{\link[=secsse_ml]{secsse_ml()}}).
}
\examples{
traits <- sample(c(0,1,2), 45,replace = TRUE) #get some traits
num_concealed_states <- 3
param_posit <- id_paramPos(traits,num_concealed_states)
}
