% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_utils.R
\name{q_doubletrans}
\alias{q_doubletrans}
\title{Basic Qmatrix
Sets a Q matrix where double transitions are not allowed}
\usage{
q_doubletrans(traits, masterBlock, diff.conceal)
}
\arguments{
\item{traits}{vector with trait states for each tip in the phylogeny. The
order of the states must be the same as the tree tips. For help, see
\code{vignette("starting_secsse", package = "secsse")}. When providing a
\code{multiPhylo} set of multiple phylognies, traits should be a list where
each entry in the list corresponds to the matching phylogeny on that
position.}

\item{masterBlock}{matrix of transitions among only examined states, \code{NA} in
the main diagonal, used to build the full transition rates matrix.}

\item{diff.conceal}{Boolean stating if the concealed states should be
different. E.g. that the transition rates for the concealed
states are different from the transition rates for the examined states.
Normally it should be \code{FALSE} in order to avoid having a huge number of
parameters.}
}
\value{
Q matrix that includes both examined and concealed states, it should
be declared as the third element of idparslist.
}
\description{
This function expands the Q_matrix, but it does so assuming
that the number of concealed traits is equal to the number of examined
traits, if you have a different number, you should consider looking at
the function \code{\link[=expand_q_matrix]{expand_q_matrix()}}.
}
\examples{
traits <- sample(c(0,1,2), 45,replace = TRUE) #get some traits
# For a three-state trait
masterBlock <- matrix(99,ncol = 3,nrow = 3,byrow = TRUE)
diag(masterBlock) <- NA
masterBlock[1,2] <- 6
masterBlock[1,3] <- 7
masterBlock[2,1] <- 8
masterBlock[2,3] <- 9
masterBlock[3,1] <- 10
masterBlock[3,2] <- 11
myQ <- q_doubletrans(traits,masterBlock,diff.conceal = FALSE)
# now, it can replace the Q matrix from id_paramPos
num_concealed_states <- 3
param_posit <- id_paramPos(traits,num_concealed_states)
param_posit[[3]] <- myQ
}
