% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_eval.R
\name{geweke_test}
\alias{geweke_test}
\title{Geweke test for convergence}
\usage{
geweke_test(x, frac1 = 0.1, frac2 = 0.5, alpha = 0.05)
}
\arguments{
\item{x}{\code{R x n} matrix with \code{R} draws of \code{n} variables}

\item{frac1}{probability mass of the first interval, a scalar between zero and one}

\item{frac2}{probability mass of the second interval, a scalar between zero and one}

\item{alpha}{significance level used to compute the test decision, a scalar between
zero and one}
}
\value{
A list with the following items
\describe{
\item{h}{Test decision.}
\item{CD}{Convergence Diagnostic (test statistic).}
\item{pvalue}{The p-value.}
\item{alpha}{The applied signifcicance level.}
\item{frac1}{The fraction of data contained in the first interval.}
\item{frac2}{The fraction of data contained in the second interval.}
}
}
\description{
Conducts a Geweke test for convergence of the draws.
}
\details{
Under the H0 of convergence, the test statistic is standard normally distributed.

Naturally, \code{frac1 + frac2} is between zero and one.
}
\keyword{internal}
