% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{simgl}
\alias{simgl}
\title{Simulate genotype (log) likelihoods from genotype counts}
\usage{
simgl(nvec, rd = 10, seq = 0.01, bias = 1, od = 0.01)
}
\arguments{
\item{nvec}{A vector of counts. \code{nvec[k]} is the number of folks with a genotype of k-1.}

\item{rd}{Read depth. Lower is more uncertain.}

\item{seq}{Sequencing error rate. Higher means more uncertain.}

\item{bias}{Bias. 1 means no bias.}

\item{od}{Overdispersion. Typical value is like 0.01. Higher means more uncertain.}
}
\value{
A matrix of genotype log-likelihoods. The rows index the
individuals and the columns index the genotypes. This is natural
log (base e).
}
\description{
Provide a vector of genotype counts and this will return a matrix of
genotype log-likelihoods.
}
\examples{
set.seed(1)
simgl(nvec = c(1, 2, 1, 1, 3))

}
\author{
David Gerard
}
